/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.analog;

import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.ClientComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSource;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.lib.util.value.Reference;
import com.technicalitiesmc.scm.component.CircuitComponentBase;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import com.technicalitiesmc.scm.init.SCMComponents;
import com.technicalitiesmc.scm.init.SCMItems;
import com.technicalitiesmc.scm.menu.ConstantMenu;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;

public class ConstantComponent
extends CircuitComponentBase<ConstantComponent> {
    private static final VecDirectionFlags OUTPUT_SIDES = VecDirectionFlags.horizontals();
    private static final AABB BOUNDS = new AABB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    private static final TranslatableComponent MENU_TITLE = new TranslatableComponent("container.supercircuitmaker.constant");
    private static final InterfaceLookup<ConstantComponent> INTERFACES = InterfaceLookup.builder().with(RedstoneSource.class, OUTPUT_SIDES, ConstantComponent::getRedstoneSource).build();
    private int output;

    public ConstantComponent(ComponentContext context) {
        super(SCMComponents.CONSTANT, context, INTERFACES);
    }

    public AABB getBoundingBox() {
        return BOUNDS;
    }

    public ItemStack getPickedItem() {
        return new ItemStack((ItemLike)SCMItems.CONSTANT.get());
    }

    public InteractionResult use(Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
        player.m_5893_((MenuProvider)new SimpleMenuProvider((id, playerInv, $) -> new ConstantMenu(id, playerInv, p -> true, (Reference<Integer>)Reference.of(() -> this.output, this::setOutput)), (Component)MENU_TITLE));
        return InteractionResult.m_19078_((boolean)false);
    }

    public CompoundTag save(CompoundTag tag) {
        tag.m_128405_("output", this.output);
        return tag;
    }

    public void load(CompoundTag tag) {
        this.output = tag.m_128451_("output");
    }

    private void setOutput(int output) {
        this.updateExternalState(false, () -> {
            this.output = output;
        });
        this.sendEvent(CircuitEvent.REDSTONE, OUTPUT_SIDES);
    }

    private RedstoneSource getRedstoneSource(VecDirection side) {
        return RedstoneSource.of((int)0, (int)this.output);
    }

    public static class Client
    extends ClientComponent {
        public AABB getBoundingBox(ComponentState state) {
            return BOUNDS;
        }

        public ItemStack getPickedItem(ComponentState state) {
            return new ItemStack((ItemLike)SCMItems.CONSTANT.get());
        }

        public InteractionResult use(ComponentState state, Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
            return InteractionResult.m_19078_((boolean)true);
        }
    }
}

